--PolyTools Macroscripts----------------------------

Macroscript Loop
category: ~LOOP_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~LOOP_TOOLTIP~
buttontext:~LOOP_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.Loop keyboard.shiftpressed
)

Macroscript Ring
category: ~RING_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~RING_TOOLTIP~
buttontext:~RING_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.Ring()
)

Macroscript GrowLoop
category: ~GROWLOOP_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~GROWLOOP_TOOLTIP~
buttontext: ~GROWLOOP_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.GrowLoop()
)

Macroscript ShrinkLoop
category: ~SHRINKLOOP_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SHRINKLOOP_TOOLTIP~
buttontext: ~SHRINKLOOP_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.ShrinkLoop()
)

Macroscript GrowRing
category: ~GROWRING_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~GROWRING_TOOLTIP~
buttontext: ~GROWRING_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and (subobjectlevel == 2 or subobjectlevel == 3))
on execute do PolytoolsSelect.GrowRing()
)

Macroscript ShrinkRing
category: ~SHRINKRING_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SHRINKRING_TOOLTIP~
buttontext: ~SHRINKRING_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and (subobjectlevel == 2 or subobjectlevel == 3))
on execute do PolytoolsSelect.ShrinkRing()
)

Macroscript Outline
category: ~OUTLINE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~OUTLINE_TOOLTIP~
buttontext: ~OUTLINE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.Outline()
)

Macroscript Tops
category: ~TOPS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPS_TOOLTIP~
buttontext: ~TOPS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.Tops keyboard.shiftpressed
)

Macroscript Similar
category: ~SIMILAR_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SIMILAR_TOOLTIP~
buttontext: ~SIMILAR_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyBoost.SimilarSelect()
)

Macroscript SimilarQuick
category: ~SIMILARQUICK_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SIMILARQUICK_TOOLTIP~
buttontext: ~SIMILARQUICK_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do
(
	if subobjectLevel == 1 then
	(
		PolytoolsSelect.Similar true true true false false false
	)
	else if subobjectLevel == 2 or subobjectLevel == 3 then
	(
		PolytoolsSelect.Similar false true false true false false
	)
	else if subobjectLevel == 4 or subobjectLevel == 5 do
	(
		PolytoolsSelect.Similar true false false true true false
	)
)
)

Macroscript SharpEdges
category: ~SHARPEDGES_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SHARPEDGES_TOOLTIP~
buttontext: ~SHARPEDGES_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and (subobjectlevel == 2 or subobjectlevel == 3))
on execute do PolytoolsSelect.HardEdges()
)

Macroscript InsertLoop
category: ~INSERTLOOP_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~INSERTLOOP_TOOLTIP~
buttontext: ~INSERTLOOP_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyBoost.Insloopfunc()
)

Macroscript RemoveLoop
category: ~REMOVELOOP_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~REMOVELOOP_TOOLTIP~
buttontext: ~REMOVELOOP_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsModeling.RemoveLoop()
)

Macroscript Smooth
category: ~SMOOTH_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SMOOTH_TOOLTIP~
buttontext: ~SMOOTH_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPbasemacro()
on execute do
(
	PolyToolsUI.SmoothType = 1
	PolyBoost.Smoothfunc false
)
)

Macroscript SmoothSelection
category: ~SMOOTHSELECTION_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SMOOTHSELECTION_TOOLTIP~
buttontext: ~SMOOTHSELECTION_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do
(
	PolyToolsUI.SmoothType = 2
	PolyBoost.Smoothfunc true
)
)

Macroscript Hard
category: ~HARD_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~HARD_TOOLTIP~
buttontext: ~HARD_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPbasemacro()
on execute do
(
	PolyToolsUI.HardType = 1
	PolyBoost.Hardfunc false
)
)

Macroscript HardSelection
category: ~HARDSELECTION_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~HARDSELECTION_TOOLTIP~
buttontext: ~HARDSELECTION_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do
(
	PolyToolsUI.HardType = 2
	PolyBoost.Hardfunc true
)
)

Macroscript SmoothThirty
category: ~SMOOTHTHIRTY_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SMOOTHTHIRTY_TOOLTIP~
buttontext: ~SMOOTHTHIRTY_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPbasemacro()
on execute do
(
	PolyToolsUI.Smooth30Type = 1
	PolyBoost.Thirtyfunc false
)
)

Macroscript SmoothThirtySelection
category: ~SMOOTHTHIRTYSELECTION_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SMOOTHTHIRTYSELECTION_TOOLTIP~
buttontext: ~SMOOTHTHIRTYSELECTION_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do
(
	PolyToolsUI.Smooth30Type = 2
	PolyBoost.Thirtyfunc true
)
)

Macroscript Random
category: ~RANDOM_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~RANDOM_TOOLTIP~
buttontext: ~RANDOM_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do
(
	PolytoolsSelect.Random PolyToolsUI.RandomPercent PolyToolsUI.RandomNumber PolyToolsUI.RandomType keyboard.shiftpressed
)
)

Macroscript RandomDialog
category: ~RANDOMDIALOG_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~RANDOMDIALOG_TOOLTIP~
buttontext: ~RANDOMDIALOG_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyBoost.RandDfunc()
)

Macroscript RandomGrow
category: ~RANDOMGROW_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~RANDOMGROW_TOOLTIP~
buttontext: ~RANDOMGROW_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.RandomGrow()
)

Macroscript RandomShrink
category: ~RANDOMSHRINK_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~RANDOMSHRINK_TOOLTIP~
buttontext: ~RANDOMSHRINK_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.RandomShrink()
)

Macroscript Pattern1
category: ~PATTERN1_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PATTERN1_TOOLTIP~
buttontext: ~PATTERN1_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.Pattern1 1
)

Macroscript Pattern2
category: ~PATTERN2_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PATTERN2_TOOLTIP~
buttontext: ~PATTERN2_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.Pattern2 1
)

Macroscript Pattern3
category: ~PATTERN3_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PATTERN3_TOOLTIP~
buttontext: ~PATTERN3_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.Pattern3 1
)

Macroscript Pattern4
category: ~PATTERN4_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PATTERN4_TOOLTIP~
buttontext: ~PATTERN4_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.Pattern4 1
)

Macroscript Pattern5
category: ~PATTERN5_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PATTERN5_TOOLTIP~
buttontext: ~PATTERN5_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.Pattern5 1
)

Macroscript Pattern6
category: ~PATTERN6_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PATTERN6_TOOLTIP~
buttontext: ~PATTERN6_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.Pattern6 1
)

Macroscript Pattern7
category: ~PATTERN7_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PATTERN7_TOOLTIP~
buttontext: ~PATTERN7_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.Pattern7 1
)

Macroscript Pattern8
category: ~PATTERN8_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PATTERN8_TOOLTIP~
buttontext: ~PATTERN8_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.Pattern8 1
)

Macroscript GrowLine
category: ~GROWLINE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~GROWLINE_TOOLTIP~
buttontext: ~GROWLINE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.PatternGrowLine 1
)

Macroscript Checker
category: ~CHECKER_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~CHECKER_TOOLTIP~
buttontext: ~CHECKER_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.PatternChecker 1
)

Macroscript OneRing
category: ~ONERING_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~ONERING_TOOLTIP~
buttontext: ~ONERING_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and subobjectlevel > 3)
on execute do PolytoolsSelect.PatternOneRing 1
)

Macroscript Dots
category: ~DOTS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~DOTS_TOOLTIP~
buttontext: ~DOTS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.PatternDots 1
)

Macroscript Store
category: ~STORE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~STORE_TOOLTIP~
buttontext: ~STORE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyBoost.Storefunc()
)

Macroscript Paste
category: ~PASTE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PASTE_TOOLTIP~
buttontext: ~PASTE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyBoost.Pastefunc()
)

Macroscript SelectionToMap
category: ~SELECTIONTOMAP_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SELECTIONTOMAP_TOOLTIP~
buttontext: ~SELECTIONTOMAP_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1 and (Modpanel.getcurrentObject () == $.baseobject) and classof $.baseobject == Editable_Poly and subobjectlevel != 0)
on execute do
	(
	if keyboard.shiftpressed then PolyBSelToBitmap $ 512 512 1 0
	else PolyBSelToBitmap $ 256 256 1 0
	)
)

Macroscript Even
category: ~EVEN_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~EVEN_TOOLTIP~
buttontext: ~EVEN_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.Even 1 keyboard.shiftpressed
)

Macroscript Odd
category: ~ODD_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~ODD_TOOLTIP~
buttontext: ~ODD_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolytoolsSelect.Odd 1 keyboard.shiftpressed
)

Macroscript PerspectiveSelect
category: ~PERSPECTIVESELECT_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PERSPECTIVESELECT_TOOLTIP~
buttontext: ~PERSPECTIVESELECT_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do 
	(
	if subobjectlevel == 2 or subobjectlevel == 3 then
	(
		PolytoolsSelect.Perspective 30.0 true
	)
	else PolytoolsSelect.Perspective 30.0 false
	)
)

Macroscript LoopModeToggle
category: ~LOOPMODETOGGLE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~LOOPMODETOGGLE_TOOLTIP~
buttontext: ~LOOPMODETOGGLE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on isChecked do
(
	PolyToolsUI.LoopModeButton
)
on execute do
(
	PolyToolsUI.LoopModeButton = not PolyToolsUI.LoopModeButton
	PolyToolsUI.RingModeButton = false
	PolyToolsUI.StepModeButton = false
	updateToolbarButtons()
	PolyBoost.ModeLoopRing 1
)
)

Macroscript RingModeToggle
category: ~RINGMODETOGGLE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~RINGMODETOGGLE_TOOLTIP~
buttontext: ~RINGMODETOGGLE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on isChecked do
(
	PolyToolsUI.RingModeButton
)
on execute do
(
	PolyToolsUI.RingModeButton = not PolyToolsUI.RingModeButton
	PolyToolsUI.LoopModeButton = false
	PolyToolsUI.StepModeButton = false
	updateToolbarButtons()
	PolyBoost.ModeLoopRing 2
)
)

Macroscript StepModeToggle
category: ~STEPMODETOGGLE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~STEPMODETOGGLE_TOOLTIP~
buttontext: ~STEPMODETOGGLE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on isChecked do
(
	PolyToolsUI.StepModeButton
)
on execute do
(
	PolyToolsUI.StepModeButton = not PolyToolsUI.StepModeButton
	PolyToolsUI.LoopModeButton = false
	PolyToolsUI.RingModeButton = false
	updateToolbarButtons()
	PolyBoost.Stepfunc()
)
)

Macroscript DotLoop
category: ~DOTLOOP_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~DOTLOOP_TOOLTIP~
buttontext: ~DOTLOOP_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do
(
	PolytoolsSelect.DotLoop PolyToolsUI.DotLoopGap keyboard.shiftpressed keyboard.altpressed
)
)

Macroscript DotRing
category: ~DOTRING_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~DOTRING_TOOLTIP~
buttontext: ~DOTRING_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and (subobjectlevel == 2 or subobjectlevel == 3))
on execute do PolytoolsSelect.DotRing PolyToolsUI.DotLoopGap
)

Macroscript BuildLoopEnd
category: ~BUILDLOOPEND_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~BUILDLOOPEND_TOOLTIP~
buttontext: ~BUILDLOOPEND_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and subobjectlevel != 0 and subobjectlevel < 4)
on execute do PolyToolsModeling.BuildEnd()
)

Macroscript BuildLoopCorner
category: ~BUILDLOOPCORNER_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~BUILDLOOPCORNER_TOOLTIP~
buttontext: ~BUILDLOOPCORNER_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and subobjectlevel != 0 and subobjectlevel < 4)
on execute do PolyToolsModeling.BuildCorner()
)

Macroscript DistanceConnect
category: ~DISTANCECONNECT_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~DISTANCECONNECT_TOOLTIP~
buttontext: ~DISTANCECONNECT_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and subobjectlevel != 0 and subobjectlevel < 4)
on execute do PolyToolsModeling.DistanceConnect()
)

Macroscript Fill
category: ~FILL_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~FILL_TOOLTIP~
buttontext: ~FILL_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsSelect.Fill()
)

Macroscript FillHole
category: ~FILLHOLE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~FILLHOLE_TOOLTIP~
buttontext: ~FILLHOLE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsSelect.FillHole()
)

Macroscript RandomConnect
category: ~RANDOMCONNECT_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~RANDOMCONNECT_TOOLTIP~
buttontext: ~RANDOMCONNECT_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and (subobjectlevel == 2 or subobjectlevel == 3))
on execute do PolyBoost.Randconfunc()
)

Macroscript FlowConnect
category: ~FLOWCONNECT_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~FLOWCONNECT_TOOLTIP~
buttontext: ~FLOWCONNECT_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and (subobjectlevel == 2 or subobjectlevel == 3))
on execute do PolyBoost.Flowfunc true
)

Macroscript LoopTools
category: ~LOOPTOOLS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~LOOPTOOLS_TOOLTIP~
buttontext: ~LOOPTOOLS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyBoost.FlowDfunc()
)

Macroscript SelectionToBase
category: ~SELECTIONTOBASE_CATEGORY~
internalCategory: "UVW Unwrap"
tooltip: ~SELECTIONTOBASE_TOOLTIP~
buttontext: ~SELECTIONTOBASE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidUV()
on execute do PolyBUVToPoly (modpanel.getcurrentobject())
)

Macroscript UV_SelectionFromBase
category: ~UV_SELECTIONFROMBASE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~UV_SELECTIONFROMBASE_TOOLTIP~
buttontext: ~UV_SELECTIONFROMBASE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.validUV2()
on execute do PolyBoost.UV_ToUvfunc()
)

Macroscript UV_Loop
category: ~UV_LOOP_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~UV_LOOP_TOOLTIP~
buttontext: ~UV_LOOP_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidUV()
on execute do PolyBUVLoop (modpanel.getcurrentobject())
)

Macroscript UV_Ring
category: ~UV_RING_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~UV_RING_TOOLTIP~
buttontext: ~UV_RING_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidUV()
on execute do PolyBUVRing (modpanel.getcurrentobject())
)

Macroscript UV_GrowLoop
category: ~UV_GROWLOOP_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~UV_GROWLOOP_TOOLTIP~
buttontext: ~UV_GROWLOOP_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidUV()
on execute do PolyBUVGrowLoop (modpanel.getcurrentobject())
)

Macroscript UV_ShrinkLoop
category: ~UV_SHRINKLOOP_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~UV_SHRINKLOOP_TOOLTIP~
buttontext: ~UV_SHRINKLOOP_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidUV()
on execute do PolyBUVShrinkLoop (modpanel.getcurrentobject())
)

Macroscript UV_GrowRing
category: ~UV_GROWRING_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~UV_GROWRING_TOOLTIP~
buttontext: ~UV_GROWRING_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidUV() and PolyBoost.validUVlevel 2)
on execute do PolyBUVGrowRing (modpanel.getcurrentobject())
)

Macroscript RotateCW
category: ~ROTATECW_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~ROTATECW_TOOLTIP~
buttontext: ~ROTATECW_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do 
	(
	if keyboard.shiftpressed then PolyBoost.SmartRotate 30
	else PolyBoost.SmartRotate 90
	)
)

Macroscript RotateCCW
category: ~ROTATECCW_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~ROTATECCW_TOOLTIP~
buttontext: ~ROTATECCW_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do
	(
	if keyboard.shiftpressed then PolyBoost.SmartRotate -30
	else PolyBoost.SmartRotate -90
	)
)

Macroscript ResetXForm
category: ~RESETXFORM_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~RESETXFORM_TOOLTIP~
buttontext: ~RESETXFORM_TOOLTIP~
(
on isEnabled return (selection.count != 0)
on execute do PolyBoost.Resetxfunc()
)

Macroscript GetSize
category: ~GETSIZE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~GETSIZE_TOOLTIP~
buttontext: ~GETSIZE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do PolyBoost.GetSizefunc()
)

Macroscript CenterPivot
category: ~CENTERPIVOT_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~CENTERPIVOT_TOOLTIP~
buttontext: ~CENTERPIVOT_TOOLTIP~
(
on isEnabled return (selection.count != 0)
on execute do (for i in selection do i.pivot = i.center)
)

Macroscript PivotToOrigin
category: ~PIVOTTOORIGIN_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PIVOTTOORIGIN_TOOLTIP~
buttontext: ~PIVOTTOORIGIN_TOOLTIP~
(
on isEnabled return (selection.count != 0)
on execute do (for i in selection do i.pivot = [0,0,0])
)

Macroscript ObjectToCenter
category: ~OBJECTTOCENTER_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~OBJECTTOCENTER_TOOLTIP~
buttontext: ~OBJECTTOCENTER_TOOLTIP~
(
on isEnabled return (selection.count != 0)
on execute do (for i in selection do i.pos = [0,0,0])
)

Macroscript Quickclone
category: ~QUICKCLONE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~QUICKCLONE_TOOLTIP~
buttontext: ~QUICKCLONE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do
	(
	if keyboard.altpressed do PolyBoost.Clonefunc()
	PolyBoost.Clonefunc()
	)
)

Macroscript Topology
category: ~TOPOLOGY_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOLOGY_TOOLTIP~
buttontext: ~TOPOLOGY_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPbasemacro()
on execute do PolyBoost.topology()
)

Macroscript TopoWall
category: ~TOPOWALL_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOWALL_TOOLTIP~
buttontext: ~TOPOWALL_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.Wall()
)

Macroscript TopoTiles
category: ~TOPOTILES_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOTILES_TOOLTIP~
buttontext: ~TOPOTILES_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.Tiles1()
)

Macroscript TopoTiles2
category: ~TOPOTILES2_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOTILES2_TOOLTIP~
buttontext: ~TOPOTILES2_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.Tiles2()
)

Macroscript TopoBrick
category: ~TOPOBRICK_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOBRICK_TOOLTIP~
buttontext: ~TOPOBRICK_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and (subobjectlevel == 2 or subobjectlevel == 3))
on execute do PolyToolsTopology.Brick()
)

Macroscript TopoHive
category: ~TOPOHIVE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOHIVE_TOOLTIP~
buttontext: ~TOPOHIVE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and (subobjectlevel == 2 or subobjectlevel == 3))
on execute do PolyToolsTopology.Hive()
)

Macroscript TopoMosaic
category: ~TOPOMOSAIC_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOMOSAIC_TOOLTIP~
buttontext: ~TOPOMOSAIC_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.Mosiac()
)

Macroscript TopoFloor
category: ~TOPOFLOOR_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOFLOOR_TOOLTIP~
buttontext: ~TOPOFLOOR_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.Floor1()
)

Macroscript TopoFloor2
category: ~TOPOFLOOR2_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOFLOOR2_TOOLTIP~
buttontext: ~TOPOFLOOR2_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.Floor2()
)

Macroscript TopoSkin
category: ~TOPOSKIN_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOSKIN_TOOLTIP~
buttontext: ~TOPOSKIN_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.Skin()
)

Macroscript TopoHoler
category: ~TOPOHOLER_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOHOLER_TOOLTIP~
buttontext: ~TOPOHOLER_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.Holer()
)

Macroscript TopoEdgedir
category: ~TOPOEDGEDIR_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOEDGEDIR_TOOLTIP~
buttontext: ~TOPOEDGEDIR_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.EdgeDirection()
)

Macroscript TopoSimplify
category: ~TOPOSIMPLIFY_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOSIMPLIFY_TOOLTIP~
buttontext: ~TOPOSIMPLIFY_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.Simplify()
)

Macroscript TopoChaos
category: ~TOPOCHAOS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOCHAOS_TOOLTIP~
buttontext: ~TOPOCHAOS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.Chaos()
)

Macroscript TopoFours
category: ~TOPOFOURS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOFOURS_TOOLTIP~
buttontext: ~TOPOFOURS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.Fours()
)

Macroscript TopoStars
category: ~TOPOSTARS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOSTARS_TOOLTIP~
buttontext: ~TOPOSTARS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.SmoothStar()
)

Macroscript TopoCross
category: ~TOPOCROSS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOCROSS_TOOLTIP~
buttontext: ~TOPOCROSS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.Cross()
)

Macroscript TopoPlanks
category: ~TOPOPLANKS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOPLANKS_TOOLTIP~
buttontext: ~TOPOPLANKS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.Planks1()
)

Macroscript TopoPlanks2
category: ~TOPOPLANKS2_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOPLANKS2_TOOLTIP~
buttontext: ~TOPOPLANKS2_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.Planks2()
)

Macroscript TopoPlanks3
category: ~TOPOPLANKS3_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOPLANKS3_TOOLTIP~
buttontext: ~TOPOPLANKS3_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.Planks3()
)

Macroscript TopoPlanks4
category: ~TOPOPLANKS4_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOPLANKS4_TOOLTIP~
buttontext: ~TOPOPLANKS4_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsTopology.Planks4()
)

Macroscript TopoTatter
category: ~TOPOTATTER_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TOPOTATTER_TOOLTIP~
buttontext: ~TOPOTATTER_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do (PolyToolsTopology.Tatter 1 3 3)
)

Macroscript ScrapVerts
category: ~SCRAPVERTS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SCRAPVERTS_TOOLTIP~
buttontext: ~SCRAPVERTS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPbasemacro()
on execute do PolyToolsTopology.ScrapVerts()
)

Macroscript Numeric
category: ~NUMERIC_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~NUMERIC_TOOLTIP~
buttontext: ~NUMERIC_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyBoost.NumericDfunc()
)

Macroscript InsertVert_1
category: ~INSERTVERT_1_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~INSERTVERT_1_TOOLTIP~
buttontext: ~INSERTVERT_1_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and (subobjectlevel == 2 or subobjectlevel == 3))
on execute do PolyToolsModeling.InsertVertex 1
)

Macroscript InsertVert_2
category: ~INSERTVERT_2_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~INSERTVERT_2_TOOLTIP~
buttontext: ~INSERTVERT_2_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and (subobjectlevel == 2 or subobjectlevel == 3))
on execute do PolyToolsModeling.InsertVertex 2
)

Macroscript CreatePolygon
category: ~CREATEPOLYGON_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~CREATEPOLYGON_TOOLTIP~
buttontext: ~CREATEPOLYGON_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and subobjectlevel < 4)
on execute do PolyBoost.CreatePolygon()
)

Macroscript SpinEdge
category: ~SPINEDGE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SPINEDGE_TOOLTIP~
buttontext: ~SPINEDGE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and (subobjectlevel == 2 or subobjectlevel == 3))
on execute do PolyToolsModeling.SpinEdge keyboard.shiftpressed
)

Macroscript UVvertical
category: ~UVVERTICAL_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~UVVERTICAL_TOOLTIP~
buttontext: ~UVVERTICAL_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidUV() and (PolyBoost.validUVlevel 1 or PolyBoost.validUVlevel 2))
on execute do PolyBUVLineup (modpanel.getcurrentobject()) 1 keyboard.shiftpressed
)

Macroscript UVhorizontal
category: ~UVHORIZONTAL_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~UVHORIZONTAL_TOOLTIP~
buttontext: ~UVHORIZONTAL_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidUV() and (PolyBoost.validUVlevel 1 or PolyBoost.validUVlevel 2))
on execute do PolyBUVLineup (modpanel.getcurrentobject()) 2 keyboard.shiftpressed
)

Macroscript EmptyObject
category: ~EMPTYOBJECT_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~EMPTYOBJECT_TOOLTIP~
buttontext: ~EMPTYOBJECT_TOOLTIP~
autoUndoEnabled:false
(
on execute do
(
	disablesceneredraw()
	convertTo (box isSelected:true) Editable_Mesh
	max modify mode
	meshop.deleteFaces $.baseobject #all
	convertTo $ Editable_Poly
	enablesceneredraw()
	subobjectlevel = 1
)
)
Macroscript SkinGrow
category: ~SKINGROW_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SKINGROW_TOOLTIP~
buttontext: ~SKINGROW_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidSkinMod()
on execute do PolyBoost.SkinGrow()
)

Macroscript SkinShrink
category: ~SKINSHRINK_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SKINSHRINK_TOOLTIP~
buttontext: ~SKINSHRINK_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidSkinMod()
on execute do PolyBoost.SkinShrink()
)

Macroscript SkinLoop
category: ~SKINLOOP_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SKINLOOP_TOOLTIP~
buttontext: ~SKINLOOP_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidSkinMod()
on execute do PolyBoost.SkinLoopRing 1
)

Macroscript SkinRing
category: ~SKINRING_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SKINRING_TOOLTIP~
buttontext: ~SKINRING_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidSkinMod()
on execute do PolyBoost.SkinLoopRing 2
)

Macroscript SkinElement
category: ~SKINELEMENT_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SKINELEMENT_TOOLTIP~
buttontext: ~SKINELEMENT_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidSkinMod()
on execute do PolyBoost.SkinElement()
)

Macroscript ClothElement
category: ~CLOTHELEMENT_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~CLOTHELEMENT_TOOLTIP~
buttontext: ~CLOTHELEMENT_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidClothmod()
on execute do PolyBoost.ClothElement()
)

Macroscript ClothLoop
category: ~CLOTHLOOP_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~CLOTHLOOP_TOOLTIP~
buttontext: ~CLOTHLOOP_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidClothmod()
on execute do PolyBoost.ClothLoopRing 1
)

Macroscript ClothRing
category: ~CLOTHRING_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~CLOTHRING_TOOLTIP~
buttontext: ~CLOTHRING_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidClothmod()
on execute do PolyBoost.ClothLoopRing 2
)

Macroscript ClothGrow
category: ~CLOTHGROW_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~CLOTHGROW_TOOLTIP~
buttontext: ~CLOTHGROW_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidClothmod()
on execute do PolyBoost.ClothGrowShrink 1
)

Macroscript ClothShrink
category: ~CLOTHSHRINK_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~CLOTHSHRINK_TOOLTIP~
buttontext: ~CLOTHSHRINK_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidClothmod()
on execute do PolyBoost.ClothGrowShrink 2
)

Macroscript GeoPoly
category: ~GEOPOLY_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~GEOPOLY_TOOLTIP~
buttontext: ~GEOPOLY_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and subobjectlevel > 3)
on execute do PolyToolsModeling.GeoPoly()
)

Macroscript CenterLoop
category: ~CENTERLOOP_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~CENTERLOOP_TOOLTIP~
buttontext: ~CENTERLOOP_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and (subobjectlevel == 2 or subobjectlevel == 3))
on execute do PolyToolsModeling.CenterLoop true
)

Macroscript SetFlow
category: ~SETFLOW_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SETFLOW_TOOLTIP~
buttontext: ~SETFLOW_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and subobjectlevel < 4)
on execute do 
	(
	if subobjectlevel == 2 then PolyToolsModeling.SetFlow false
	else if subobjectlevel == 1 do PolyToolsModeling.SetFlowVertex()
	)
)

Macroscript ViewportCanvas
category: ~VIEWPORTCANVAS_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~VIEWPORTCANVAS_TOOLTIP~
buttontext: ~VIEWPORTCANVAS_TOOLTIP~
autoUndoEnabled:false
(
on isChecked return PolyBoost.ViewportCanvasOpen
on execute do
	(
		filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	)
)

Macroscript Paint
category: ~PAINT_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~PAINT_TOOLTIP~
buttontext: ~PAINT_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do
(
	if (not PolyBoost.ViewportCanvasOpen) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	if (VCGetSetting 100) then --if a tool is already active
	(
		if (VCGetSetting 103) == 1 then VCanvas.EndPaintTool()
		else VCanvas.StartPaintTool 1
	)
	else VCanvas.StartPaintTool 1
)
)

Macroscript Erase
category: ~ERASE_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~ERASE_TOOLTIP~
buttontext: ~ERASE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do
(
	if (not PolyBoost.ViewportCanvasOpen) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	if (VCGetSetting 100) then --if a tool is already active
	(
		if (VCGetSetting 103) == 10 then VCanvas.EndPaintTool()
		else VCanvas.StartPaintTool 10
	)
	else VCanvas.StartPaintTool 10
)
)

Macroscript Clone
category: ~CLONE_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~CLONE_TOOLTIP~
buttontext: ~CLONE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do
(
	if (not PolyBoost.ViewportCanvasOpen) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	if (VCGetSetting 100) then --if a tool is already active
	(
		if (VCGetSetting 103) == 2 then VCanvas.EndPaintTool()
		else VCanvas.StartPaintTool 2
	)
	else VCanvas.StartPaintTool 2
)
)

Macroscript Fill
category: ~FILL2_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~FILL2_TOOLTIP~
buttontext: ~FILL2_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do
(
	if (not PolyBoost.ViewportCanvasOpen) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	if (VCGetSetting 100) then --if a tool is already active
	(
		if (VCGetSetting 103) == 8 then VCanvas.EndPaintTool()
		else VCanvas.StartPaintTool 8
	)
	else VCanvas.StartPaintTool 8
)
)

Macroscript Gradient
category: ~GRADIENT_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~GRADIENT_TOOLTIP~
buttontext: ~GRADIENT_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do
(
	if (not PolyBoost.ViewportCanvasOpen) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	if (VCGetSetting 100) then --if a tool is already active
	(
		if (VCGetSetting 103) == 14 then VCanvas.EndPaintTool()
		else VCanvas.StartPaintTool 14
	)
	else VCanvas.StartPaintTool 14
)
)

Macroscript Smudge
category: ~SMUDGE_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~SMUDGE_TOOLTIP~
buttontext: ~SMUDGE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do
(
	if (not PolyBoost.ViewportCanvasOpen) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	if (VCGetSetting 100) then --if a tool is already active
	(
		if (VCGetSetting 103) == 9 then VCanvas.EndPaintTool()
		else VCanvas.StartPaintTool 9
	)
	else VCanvas.StartPaintTool 9
)
)

Macroscript Blur
category: ~BLUR_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~BLUR_TOOLTIP~
buttontext: ~BLUR_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do
(
	if (not PolyBoost.ViewportCanvasOpen) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	if (VCGetSetting 100) then --if a tool is already active
	(
		if (VCGetSetting 103) == 3 then VCanvas.EndPaintTool()
		else VCanvas.StartPaintTool 3
	)
	else VCanvas.StartPaintTool 3
)
)

Macroscript Sharpen
category: ~SHARPEN_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~SHARPEN_TOOLTIP~
buttontext: ~SHARPEN_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do
(
	if (not PolyBoost.ViewportCanvasOpen) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	if (VCGetSetting 100) then --if a tool is already active
	(
		if (VCGetSetting 103) == 4 then VCanvas.EndPaintTool()
		else VCanvas.StartPaintTool 4
	)
	else VCanvas.StartPaintTool 4
)
)

Macroscript Contrast
category: ~CONTRAST_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~CONTRAST_TOOLTIP~
buttontext: ~CONTRAST_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do
(
	if (not PolyBoost.ViewportCanvasOpen) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	if (VCGetSetting 100) then --if a tool is already active
	(
		if (VCGetSetting 103) == 5 then VCanvas.EndPaintTool()
		else VCanvas.StartPaintTool 5
	)
	else VCanvas.StartPaintTool 5
)
)

Macroscript Dodge
category: ~DODGE_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~DODGE_TOOLTIP~
buttontext: ~DODGE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do
(
	if (not PolyBoost.ViewportCanvasOpen) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	if (VCGetSetting 100) then --if a tool is already active
	(
		if (VCGetSetting 103) == 6 then VCanvas.EndPaintTool()
		else VCanvas.StartPaintTool 6
	)
	else VCanvas.StartPaintTool 6
)
)

Macroscript Burn
category: ~BURN_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~BURN_TOOLTIP~
buttontext: ~BURN_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do
(
	if (not PolyBoost.ViewportCanvasOpen) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	if (VCGetSetting 100) then --if a tool is already active
	(
		if (VCGetSetting 103) == 7 then VCanvas.EndPaintTool()
		else VCanvas.StartPaintTool 7
	)
	else VCanvas.StartPaintTool 7
)
)

Macroscript MoveLayer
category: ~MOVELAYER_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~MOVELAYER_TOOLTIP~
buttontext: ~MOVELAYER_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do
(
	if (not PolyBoost.ViewportCanvasOpen) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	if (VCGetSetting 100) then --if a tool is already active
	(
		if (VCGetSetting 103) == 11 then VCanvas.EndPaintTool()
		else VCanvas.StartPaintTool 11
	)
	else VCanvas.StartPaintTool 11
)
)

Macroscript ScaleLayer
category: ~SCALELAYER_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~SCALELAYER_TOOLTIP~
buttontext: ~SCALELAYER_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do
(
	if (not PolyBoost.ViewportCanvasOpen) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	if (VCGetSetting 100) then --if a tool is already active
	(
		if (VCGetSetting 103) == 12 then VCanvas.EndPaintTool()
		else VCanvas.StartPaintTool 12
	)
	else VCanvas.StartPaintTool 12
)
)

Macroscript RotateLayer
category: ~ROTATELAYER_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~ROTATELAYER_TOOLTIP~
buttontext: ~ROTATELAYER_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (selection.count == 1)
on execute do
(
	if (not PolyBoost.ViewportCanvasOpen) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	if (VCGetSetting 100) then --if a tool is already active
	(
		if (VCGetSetting 103) == 13 then VCanvas.EndPaintTool()
		else VCanvas.StartPaintTool 13
	)
	else VCanvas.StartPaintTool 13
)
)

Macroscript View2DToggle
category: ~VIEW2DTOGGLE_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~VIEW2DTOGGLE_TOOLTIP~
buttontext: ~VIEW2DTOGGLE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCanvas == undefined) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	if (VCGetSetting 100) do
	(
		if (VCGetSetting 56) then VCanvas.Close2DWindow()
		else VCanvas.Open2DWindow()
	)
)
)

Macroscript LayerDialogToggle
category: ~LAYERDIALOGTOGGLE_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~LAYERDIALOGTOGGLE_TOOLTIP~
buttontext: ~LAYERDIALOGTOGGLE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCanvas == undefined) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	if (VCGetLayerSetting 9 0) then VCLayers.CloseLayerDialog()
	else if (VCGetSetting 100) do VCLayers.OpenLayerDialog()
)
)

Macroscript ColorPalette
category: ~COLORPALETTE_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~COLORPALETTE_TOOLTIP~
buttontext: ~COLORPALETTE_TOOLTIP~
autoUndoEnabled:false
(
on execute do
(
	if (VCanvas == undefined) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	VCanvas.OpenColorPalette()
)
)

Macroscript SetBrushImageColor
category: ~SETBRUSHIMAGECOLOR_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~SETBRUSHIMAGECOLOR_TOOLTIP~
buttontext: ~SETBRUSHIMAGECOLOR_TOOLTIP~
autoUndoEnabled:false
(
on execute do
(
	if (VCanvas == undefined) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	muspos = mouse.pos + [-100,100]
	if muspos.x < 0 do muspos.x = 0
	if muspos.y < 0 do muspos.y = 0
	VCanvas.isSelectingMask = false
	VCanvas.OpenBrushMenu muspos
)
)

Macroscript SetBrushImageMask
category: ~SETBRUSHIMAGEMASK_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~SETBRUSHIMAGEMASK_TOOLTIP~
buttontext: ~SETBRUSHIMAGEMASK_TOOLTIP~
autoUndoEnabled:false
(
on execute do
(
	if (VCanvas == undefined) do filein ((GetDir #maxroot) + "stdplugs\\stdscripts\\(PolyTools)\\ViewportCanvas.ms")
	muspos = mouse.pos + [-100,100]
	if muspos.x < 0 do muspos.x = 0
	if muspos.y < 0 do muspos.y = 0
	VCanvas.isSelectingMask = true
	VCanvas.OpenBrushMenu muspos
)
)

Macroscript NewLayer
category: ~NEWLAYER_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~NEWLAYER_TOOLTIP~
buttontext: ~NEWLAYER_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCGetSetting 100) do VCNewLayer()
)
)

Macroscript DeleteLayer
category: ~DELETELAYER_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~DELETELAYER_TOOLTIP~
buttontext: ~DELETELAYER_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCGetSetting 100) do VCDeleteLayer()
)
)

Macroscript DuplicateLayer
category: ~DUPLICATELAYER_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~DUPLICATELAYER_TOOLTIP~
buttontext: ~DUPLICATELAYER_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCGetSetting 100) do VCDuplicateLayer()
)
)

Macroscript MergeDownLayer
category: ~MERGEDOWNLAYER_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~MERGEDOWNLAYER_TOOLTIP~
buttontext: ~MERGEDOWNLAYER_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCGetSetting 100) do VCMergeDownLayer()
)
)

Macroscript ApplyImage
category: ~APPLYIMAGE_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~APPLYIMAGE_TOOLTIP~
buttontext: ~APPLYIMAGE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCGetSetting 100) do VCApplyImage()
)
)

Macroscript FlattenLayers
category: ~FLATTENLAYERS_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~FLATTENLAYERS_TOOLTIP~
buttontext: ~FLATTENLAYERS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCGetSetting 100) do VCFlattenLayers()
)
)

Macroscript FlipLayerHorizontal
category: ~FLIPLAYERHORIZONTAL_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~FLIPLAYERHORIZONTAL_TOOLTIP~
buttontext: ~FLIPLAYERHORIZONTAL_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCGetSetting 100) do VCFlipLayer true
)
)

Macroscript FlipLayerVertical
category: ~FLIPLAYERVERTICAL_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~FLIPLAYERVERTICAL_TOOLTIP~
buttontext: ~FLIPLAYERVERTICAL_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCGetSetting 100) do VCFlipLayer false
)
)

Macroscript LayerAdjustment
category: ~LAYERADJUSTMENT_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~LAYERADJUSTMENT_TOOLTIP~
buttontext: ~LAYERADJUSTMENT_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCGetSetting 100) do VCLayers.OpenAdjustmentDialog()
)
)

Macroscript Levels
category: ~LEVELS_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~LEVELS_TOOLTIP~
buttontext: ~LEVELS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCGetSetting 100) do VCLayers.OpenLevelsDialog()
)
)

Macroscript AutoLevels
category: ~AUTOLEVELS_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~AUTOLEVELS_TOOLTIP~
buttontext: ~AUTOLEVELS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCGetSetting 100) do VCNormalize()
)
)

Macroscript ColorBalance
category: ~COLORBALANCE_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~COLORBALANCE_TOOLTIP~
buttontext: ~COLORBALANCE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCGetSetting 100) do VCLayers.OpenColorBalanceDialog()
)
)

Macroscript InvertLayer
category: ~INVERTLAYER_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~INVERTLAYER_TOOLTIP~
buttontext: ~INVERTLAYER_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCGetSetting 100) do VCInvertLayer()
)
)

Macroscript SavePSDAs
category: ~SAVEPSDAS_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~SAVEPSDAS_TOOLTIP~
buttontext: ~SAVEPSDAS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCGetSetting 100) do
	(
		filename = getSaveFileName caption:~GETSAVEFILENAME_CAPTION~ filename:"" types:"PSD(*.psd)|*.psd"
		if filename != undefined and filename != "" do
		(
			VCSavePSD filename
		)
	)
)
)

Macroscript SaveBitmapAs
category: ~SAVEBITMAPAS_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~SAVEBITMAPAS_TOOLTIP~
buttontext: ~SAVEBITMAPAS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCGetSetting 100) do
	(
		filename = getSaveFileName caption:~SAVEBITMAPAS_CAPTION~ filename:"" types:"TIFF(*.tif)|*.tif|BMP (*.bmp)|*.bmp|Targa (*.tga)|*.tga|PNG (*.png)|*.png|JPEG (*.jpg)|*.jpg"
		if filename != undefined and filename != "" do
		(
			texWidth = VCGetSetting 101
			texHeight = VCGetSetting 102
			tex = bitmap texWidth texHeight
			result = VCFillInBitmap tex
			tex.filename = filename
			save tex
			close tex
		)
	)
)
)

Macroscript LoadBitmapIntoLayer
category: ~LOADBITMAPINTOLAYER_CATEGORY~
internalCategory: "Viewport Canvas"
tooltip: ~LOADBITMAPINTOLAYER_TOOLTIP~
buttontext: ~LOADBITMAPINTOLAYER_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (VCGetSetting 100)
on execute do
(
	if (VCGetSetting 100) do
	(
		tex = selectBitmap caption:~LOADBITMAPINTOLAYER_CAPTION~
		if tex != undefined do
		(
			VCLoadBitmapIntoLayer tex
			close tex
		)
	)
)
)

Macroscript Multihide
category: ~MULTIHIDE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~MULTIHIDE_TOOLTIP~
buttontext: ~MULTIHIDE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPbasemacro()
on execute do PolyToolsModeling.MultiHide()
)

Macroscript Quadrify
category: ~QUADRIFY_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~QUADRIFY_TOOLTIP~
buttontext: ~QUADRIFY_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPbasemacro()
on execute do PolyToolsModeling.Quadrify keyboard.shiftpressed keyboard.altpressed
)

Macroscript Space_Loops
category: ~SPACE_LOOPS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SPACE_LOOPS_TOOLTIP~
buttontext: ~SPACE_LOOPS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and (subobjectlevel == 2 or subobjectlevel == 3))
on execute do PolyToolsModeling.SpaceLoop false
)

Macroscript Curve_Loops
category: ~CURVE_LOOPS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~CURVE_LOOPS_TOOLTIP~
buttontext: ~CURVE_LOOPS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and subobjectlevel < 4)
on execute do PolyToolsModeling.CurveLoop false true
)

Macroscript Circle_Loops
category: ~CIRCLE_LOOPS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~CIRCLE_LOOPS_TOOLTIP~
buttontext: ~CIRCLE_LOOPS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and subobjectlevel < 4)
on execute do PolyToolsModeling.CircleLoop false
)

Macroscript Straighten_Loops
category: ~STRAIGHTEN_LOOPS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~STRAIGHTEN_LOOPS_TOOLTIP~
buttontext: ~STRAIGHTEN_LOOPS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and subobjectlevel < 4)
on execute do PolyToolsModeling.StraightLoop false false
)

Macroscript Relax_Loops
category: ~RELAX_LOOPS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~RELAX_LOOPS_TOOLTIP~
buttontext: ~RELAX_LOOPS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and (subobjectlevel == 2 or subobjectlevel == 3))
on execute do PolyToolsModeling.RelaxLoop false
)

Macroscript UV_Stitch
category: ~UV_STITCH_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~UV_STITCH_TOOLTIP~
buttontext: ~UV_STITCH_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidUV()
on execute do PolyBUVStitch (modpanel.getcurrentobject()) keyboard.shiftpressed
)

Macroscript StepLoop
category: ~STEPLOOP_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~STEPLOOP_TOOLTIP~
buttontext: ~STEPLOOP_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsSelect.StepLoop keyboard.altpressed
)

Macroscript SymmetrySelectX
category: ~SYMMETRYSELECTX_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SYMMETRYSELECTX_TOOLTIP~
buttontext: ~SYMMETRYSELECTX_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsSelect.Symmetry 0
)

Macroscript SymmetrySelectY
category: ~SYMMETRYSELECTY_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SYMMETRYSELECTY_TOOLTIP~
buttontext: ~SYMMETRYSELECTY_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsSelect.Symmetry 1
)

Macroscript SymmetrySelectZ
category: ~SYMMETRYSELECTZ_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SYMMETRYSELECTZ_TOOLTIP~
buttontext: ~SYMMETRYSELECTZ_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsSelect.Symmetry 2
)

Macroscript Symmetry_Tools
category: ~SYMMETRY_TOOLS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SYMMETRY_TOOLS_TOOLTIP~
buttontext: ~SYMMETRY_TOOLS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPbasemacro()
on execute do PolyBoost.SymmetryD()
)

Macroscript UV_SpaceVertical
category: ~UV_SPACEVERTICAL_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~UV_SPACEVERTICAL_TOOLTIP~
buttontext: ~UV_SPACEVERTICAL_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidUV()
on execute do PolyBUVSpace (modpanel.getcurrentobject()) 1 keyboard.shiftpressed
)

Macroscript UV_SpaceHorizontal
category: ~UV_SPACEHORIZONTAL_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~UV_SPACEHORIZONTAL_TOOLTIP~
buttontext: ~UV_SPACEHORIZONTAL_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidUV()
on execute do PolyBUVSpace (modpanel.getcurrentobject()) 0 keyboard.shiftpressed
)

Macroscript OpenSelect
category: ~OPENSELECT_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~OPENSELECT_TOOLTIP~
buttontext: ~OPENSELECT_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do 
	(
	if subobjectlevel == 4 or subobjectlevel == 5 then PolyToolsSelect.NumericFace 4 5 keyboard.shiftpressed
	else if subobjectlevel == 2 or subobjectlevel == 3 then PolyToolsSelect.NumericEdge keyboard.shiftpressed
	else if subobjectlevel == 1 do PolyToolsSelect.NumericVertex 0 4 keyboard.shiftpressed
	)
)

Macroscript NonQuad
category: ~NONQUAD_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~NONQUAD_TOOLTIP~
buttontext: ~NONQUAD_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return (PolyBoost.ValidEPmacro() and subobjectlevel > 3)
on execute do PolyToolsSelect.NumericFace 4 4 keyboard.shiftpressed
)

Macroscript Symmetry_Pos_To_Neg
category: ~SYMMETRY_POS_TO_NEG_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SYMMETRY_POS_TO_NEG_TOOLTIP~
buttontext: ~SYMMETRY_POS_TO_NEG_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return
	(
	PolyBoost.ValidEPmacro() and PBo_SDmain != undefined and SymmetryMainModel != undefined and isvalidobj SymmetryMainModel and classof SymmetryMainModel == Editable_Poly
	)
on execute do
(
	doaxis = #X
	if PBo_SDmain.axirad.state == 2 then doaxis = #Y
	else if PBo_SDmain.axirad.state == 3 do doaxis = #Z
	PolyToolsModeling.SymmetryPosToNeg doaxis
)
)

Macroscript Symmetry_Neg_To_Pos
category: ~SYMMETRY_NEG_TO_POS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SYMMETRY_NEG_TO_POS_TOOLTIP~
buttontext: ~SYMMETRY_NEG_TO_POS_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return
	(
	PolyBoost.ValidEPmacro() and PBo_SDmain != undefined and SymmetryMainModel != undefined and isvalidobj SymmetryMainModel and classof SymmetryMainModel == Editable_Poly
	)
on execute do
(
	doaxis = #X
	if PBo_SDmain.axirad.state == 2 then doaxis = #Y
	else if PBo_SDmain.axirad.state == 3 do doaxis = #Z
	PolyToolsModeling.SymmetryNegToPos doaxis
)
)

Macroscript Symmetry_Flip
category: ~SYMMETRY_FLIP_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SYMMETRY_FLIP_TOOLTIP~
buttontext: ~SYMMETRY_FLIP_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return
	(
	PolyBoost.ValidEPmacro() and PBo_SDmain != undefined and SymmetryMainModel != undefined and isvalidobj SymmetryMainModel and classof SymmetryMainModel == Editable_Poly
	)
on execute do
(
	doaxis = #X
	if PBo_SDmain.axirad.state == 2 then doaxis = #Y
	else if PBo_SDmain.axirad.state == 3 do doaxis = #Z
	PolyToolsModeling.SymmetryFlip doaxis
)
)

Macroscript Symmetry_Copy
category: ~SYMMETRY_COPY_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SYMMETRY_COPY_TOOLTIP~
buttontext: ~SYMMETRY_COPY_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return
	(
	PolyBoost.ValidEPmacro() and PBo_SDmain != undefined and SymmetryMainModel != undefined and isvalidobj SymmetryMainModel and classof SymmetryMainModel == Editable_Poly
	)
on execute do PolyToolsModeling.SymmetryCopy()
)

Macroscript Symmetry_Paste
category: ~SYMMETRY_PASTE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SYMMETRY_PASTE_TOOLTIP~
buttontext: ~SYMMETRY_PASTE_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return
	(
	PolyBoost.ValidEPmacro() and PBo_SDmain != undefined and SymmetryMainModel != undefined and isvalidobj SymmetryMainModel and classof SymmetryMainModel == Editable_Poly
	)
on execute do PolyToolsModeling.SymmetryPaste()
)

Macroscript TransformTools
category: ~TRANSFORMTOOLS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TRANSFORMTOOLS_TOOLTIP~
buttontext:~TRANSFORMTOOLS_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked return PolyBoost.TransformDialogOpen
	on execute do PolyBoost.TransformRollout()
)

Macroscript TextureTools
category: ~TEXTURETOOLS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~TEXTURETOOLS_TOOLTIP~
buttontext: ~TEXTURETOOLS_TOOLTIP~
(
	on isChecked return PolyBoost.TextureToolsOpen
	on execute do PolyBoost.TextureRollout()
)

--Ribbon macros
Macroscript PolyDrawStepBuild
category: ~POLYDRAWSTEPBUILD_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAWSTEPBUILD_TOOLTIP~
buttontext: ~POLYDRAWSTEPBUILD_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return PolyBoost.ValidEPbasemacro()
	on isChecked do
	(
		PolyToolsUI.PDButtons[1]
	)
	on execute do 
	(
		PolyToolsUI.PDButtons[1] = not PolyToolsUI.PDButtons[1]
		PolyBoost.ToolToggle 1 1 PolyToolsUI.PDButtons[1]
	)
)

Macroscript PaintConnect
category: ~PAINTCONNECT_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PAINTCONNECT_TOOLTIP~
buttontext: ~PAINTCONNECT_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return PolyBoost.ValidEPbasemacro()
	on isChecked do
	(
		PolyToolsUI.PDButtons[2]
	)
	on execute do 
	(
		PolyToolsUI.PDButtons[2] = not PolyToolsUI.PDButtons[2]
		PolyBoost.ToolToggle 1 2 PolyToolsUI.PDButtons[2]
	)
)

Macroscript SwiftLoop
category: ~SWIFTLOOP_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~SWIFTLOOP_TOOLTIP~
buttontext: ~SWIFTLOOP_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return PolyBoost.ValidEPbasemacro()
	on isChecked do
	(
		PolyToolsUI.PDButtons[3]
	)
	on execute do 
	(
		PolyToolsUI.PDButtons[3] = not PolyToolsUI.PDButtons[3]
		PolyBoost.ToolToggle 1 3 PolyToolsUI.PDButtons[3]
	)
)

Macroscript PolyDrawExtend
category: ~POLYDRAWEXTEND_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAWEXTEND_TOOLTIP~
buttontext: ~POLYDRAWEXTEND_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return PolyBoost.ValidEPbasemacro()
	on isChecked do
	(
		PolyToolsUI.PDButtons[4]
	)
	on execute do 
	(
		PolyToolsUI.PDButtons[4] = not PolyToolsUI.PDButtons[4]
		PolyBoost.ToolToggle 1 4 PolyToolsUI.PDButtons[4]
	)
)

Macroscript PolyDrawDrag
category: ~POLYDRAWDRAG_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAWDRAG_TOOLTIP~
buttontext: ~POLYDRAWDRAG_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return PolyBoost.ValidEPbasemacro()
	on isChecked do
	(
		PolyToolsUI.PDButtons[5]
	)
	on execute do 
	(
		PolyToolsUI.PDButtons[5] = not PolyToolsUI.PDButtons[5]
		PolyBoost.ToolToggle 1 5 PolyToolsUI.PDButtons[5]
	)
)

Macroscript PolyDrawOptimize
category: ~POLYDRAWOPTIMIZE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAWOPTIMIZE_TOOLTIP~
buttontext: ~POLYDRAWOPTIMIZE_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return PolyBoost.ValidEPbasemacro()
	on isChecked do
	(
		PolyToolsUI.PDButtons[6]
	)
	on execute do 
	(
		PolyToolsUI.PDButtons[6] = not PolyToolsUI.PDButtons[6]
		PolyBoost.ToolToggle 1 6 PolyToolsUI.PDButtons[6]
	)
)

Macroscript PolyDrawTopology
category: ~POLYDRAWTOPOLOGY_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAWTOPOLOGY_TOOLTIP~
buttontext: ~POLYDRAWTOPOLOGY_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.PDButtons[7]
	)
	on execute do 
	(
		PolyToolsUI.PDButtons[7] = not PolyToolsUI.PDButtons[7]
		PolyBoost.ToolToggle 1 7 PolyToolsUI.PDButtons[7]
	)
)

Macroscript PolyDrawSurface
category: ~POLYDRAWSURFACE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAWSURFACE_TOOLTIP~
buttontext: ~POLYDRAWSURFACE_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return PolyBoost.ValidEPbasemacro()
	on isChecked do
	(
		PolyToolsUI.PDButtons[8]
	)
	on execute do 
	(
		PolyToolsUI.PDButtons[8] = not PolyToolsUI.PDButtons[8]
		PolyBoost.ToolToggle 1 8 PolyToolsUI.PDButtons[8]
	)
)

Macroscript PolyDrawShapes
category: ~POLYDRAWSHAPES_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAWSHAPES_TOOLTIP~
buttontext: ~POLYDRAWSHAPES_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return PolyBoost.ValidEPbasemacro()
	on isChecked do
	(
		PolyToolsUI.PDButtons[9]
	)
	on execute do 
	(
		PolyToolsUI.PDButtons[9] = not PolyToolsUI.PDButtons[9]
		PolyBoost.ToolToggle 1 9 PolyToolsUI.PDButtons[9]
	)
)

Macroscript PolyDrawStrips
category: ~POLYDRAWSTRIPS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAWSTRIPS_TOOLTIP~
buttontext: ~POLYDRAWSTRIPS_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return PolyBoost.ValidEPbasemacro()
	on isChecked do
	(
		PolyToolsUI.PDButtons[10]
	)
	on execute do 
	(
		PolyToolsUI.PDButtons[10] = not PolyToolsUI.PDButtons[10]
		PolyBoost.ToolToggle 1 10 PolyToolsUI.PDButtons[10]
	)
)

Macroscript PolyDrawBranch
category: ~POLYDRAWBRANCH_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAWBRANCH_TOOLTIP~
buttontext: ~POLYDRAWBRANCH_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return PolyBoost.ValidEPbasemacro()
	on isChecked do
	(
		PolyToolsUI.PDButtons[11]
	)
	on execute do 
	(
		PolyToolsUI.PDButtons[11] = not PolyToolsUI.PDButtons[11]
		PolyBoost.ToolToggle 1 11 PolyToolsUI.PDButtons[11]
	)
)

Macroscript PolyDrawSplines
category: ~POLYDRAWSPLINES_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAWSPLINES_TOOLTIP~
buttontext: ~POLYDRAWSPLINES_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.PDButtons[12]
	)
	on execute do 
	(
		PolyToolsUI.PDButtons[12] = not PolyToolsUI.PDButtons[12]
		PolyBoost.ToolToggle 1 12 PolyToolsUI.PDButtons[12]
	)
)

Macroscript PolyDrawConformMove
category: ~POLYDRAW_CONFORMMOVE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAW_CONFORMMOVE_TOOLTIP~
buttontext: ~POLYDRAW_CONFORMMOVE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.PDButtons[13]
	)
	on execute do 
	(
		PolyToolsUI.PDButtons[13] = not PolyToolsUI.PDButtons[13]
		PolyBoost.ToolToggle 3 4 PolyToolsUI.PDButtons[13]
	)
)

Macroscript PolyDrawConformScale
category: ~POLYDRAW_CONFORMSCALE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAW_CONFORMSCALE_TOOLTIP~
buttontext: ~POLYDRAW_CONFORMSCALE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.PDButtons[14]
	)
	on execute do 
	(
		PolyToolsUI.PDButtons[14] = not PolyToolsUI.PDButtons[14]
		PolyBoost.ToolToggle 3 5 PolyToolsUI.PDButtons[14]
	)
)

Macroscript PolyDrawConformRotate
category: ~POLYDRAW_CONFORMROTATE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAW_CONFORMROTATE_TOOLTIP~
buttontext: ~POLYDRAW_CONFORMROTATE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.PDButtons[15]
	)
	on execute do 
	(
		PolyToolsUI.PDButtons[15] = not PolyToolsUI.PDButtons[15]
		PolyBoost.ToolToggle 3 6 PolyToolsUI.PDButtons[15]
	)
)

Macroscript PolyDrawConformRelax
category: ~POLYDRAW_CONFORMRELAX_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAW_CONFORMRELAX_TOOLTIP~
buttontext: ~POLYDRAW_CONFORMRELAX_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.PDButtons[16]
	)
	on execute do 
	(
		PolyToolsUI.PDButtons[16] = not PolyToolsUI.PDButtons[16]
		PolyBoost.ToolToggle 3 7 PolyToolsUI.PDButtons[16]
	)
)

Macroscript PolyDrawConform
category: ~POLYDRAW_CONFORM_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAW_CONFORM_TOOLTIP~
buttontext: ~POLYDRAW_CONFORM_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.PDButtons[17]
	)
	on execute do 
	(
		PolyToolsUI.PDButtons[17] = not PolyToolsUI.PDButtons[17]
		PolyBoost.ToolToggle 3 8 PolyToolsUI.PDButtons[17]
	)
)

Macroscript PolyDrawPickButton
category: ~POLYDRAWPICKBUTTON_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYDRAWPICKBUTTON_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return
	(
		isConformActive = PolyToolsUI.PDButtons[13] or PolyToolsUI.PDButtons[14] or PolyToolsUI.PDButtons[15] or PolyToolsUI.PDButtons[16] or PolyToolsUI.PDButtons[17]
		PolyToolsUI.PDDrawtype == 2 and PolyToolsUI.PDTool == 0 and not isConformActive
	)
	on isChecked do
	(
		PolyToolsUI.PDPickButton
	)
	on execute do 
	(
		if PolyToolsUI.PDPickButton then
		(
			PolyToolsUI.PDPickButton = false
			max move
		)
		else PolyBoost.PolyDrawPickNode()
	)
)

Macroscript PolyDrawTypeButton
category: ~POLYDRAWTYPEBUTTON_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYDRAWTYPEBUTTON_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return
	(
		isConformActive = PolyToolsUI.PDButtons[13] or PolyToolsUI.PDButtons[14] or PolyToolsUI.PDButtons[15] or PolyToolsUI.PDButtons[16] or PolyToolsUI.PDButtons[17]
		PolyToolsUI.PDTool == 0 and not isConformActive
	)
	on execute do 
	(
		updateToolbarButtons()
	)
)

Macroscript PolyDrawTypeGrid
category: ~POLYDRAWTYPEGRID_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAWTYPEGRID_TOOLTIP~
buttontext: ~POLYDRAWTYPEGRID_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.PDDrawtype == 1
	on execute do 
	(
		PolyToolsUI.PDDrawtype = 1
		updateToolbarButtons()
	)
)

Macroscript PolyDrawTypeSurface
category: ~POLYDRAWTYPESURFACE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAWTYPESURFACE_TOOLTIP~
buttontext: ~POLYDRAWTYPESURFACE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.PDDrawtype == 2
	on execute do 
	(
		PolyToolsUI.PDDrawtype = 2
		updateToolbarButtons()
	)
)

Macroscript PolyDrawTypeSelection
category: ~POLYDRAWTYPESELECTION_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAWTYPESELECTION_TOOLTIP~
buttontext: ~POLYDRAWTYPESELECTION_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.PDDrawtype == 3
	on execute do 
	(
		PolyToolsUI.PDDrawtype = 3
		updateToolbarButtons()
	)
)

Macroscript PolyDrawSetFlowToggle
category: ~POLYDRAWSETFLOWTOGGLE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAWSETFLOWTOGGLE_TOOLTIP~
buttontext: ~POLYDRAWSETFLOWTOGGLE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.PDSetFlow
	)
	on execute do 
	(
		PolyToolsUI.PDSetFlow = not PolyToolsUI.PDSetFlow
		PolyToolsUI.PolyDrawSettings()
	)
)

Macroscript PolyDrawAutoWeldToggle
category: ~POLYDRAWSETFLOWTOGGLE2_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAWAUTOWELDTOGGLE_TOOLTIP~
buttontext: ~POLYDRAWAUTOWELDTOGGLE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.PDAutoWeld
	)
	on execute do 
	(
		PolyToolsUI.PDAutoWeld = not PolyToolsUI.PDAutoWeld
		PolyToolsUI.PolyDrawSettings()
	)
)

Macroscript PolyDrawSurfaceQuadsToggle
category: ~POLYDRAWSURFACEQUADSTOGGLE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAWSURFACEQUADSTOGGLE_TOOLTIP~
buttontext: ~POLYDRAWSURFACEQUADSTOGGLE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.PDSurfQuads
	)
	on execute do 
	(
		PolyToolsUI.PDSurfQuads = not PolyToolsUI.PDSurfQuads
		PolyToolsUI.PolyDrawSettings()
	)
)

Macroscript PolyDrawSetSurfaceObject
category: ~POLYDRAWSETSURFACEOBJECT_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYDRAWSETSURFACEOBJECT_TOOLTIP~
buttontext: ~POLYDRAWSETSURFACEOBJECT_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return
	(
		selection.count == 1 and superclassof $ == GeometryClass and classof $ != Targetobject
	)
	on execute do 
	(
		if selection.count == 1 and superclassof $ == GeometryClass and classof $ != Targetobject do
		(
			PBo_Pickobject = $
			pickname = $.name
			ncount = pickname.count
			if pickname.count > 14 do
			(
				namm = ""
				for i = 1 to 11 do namm += pickname[i]
				namm += "..."
				pickname = namm
			)
			PolyBoost.PolyDrawPicktext = pickname
			PolyToolsUI.PDPickButton = true
			updateToolbarButtons()
		)
	)
)

Macroscript PolyDrawConformRelativeOffset
category: ~POLYDRAW_CONFORMRELATIVE_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYDRAW_CONFORMRELATIVE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.PSUseRelativeOffset
	on execute do 
	(
		PolyToolsUI.PSUseRelativeOffset = not PolyToolsUI.PSUseRelativeOffset
		PolyToolsUI.PolyShiftSettings()
	)
)

Macroscript PolyDrawConformDirNormal
category: ~POLYDRAW_CONFORMDIRNORMAL_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYDRAW_CONFORMDIRNORMAL_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		PolyToolsUI.PSConformDirection = 1
		PolyToolsUI.PolyShiftSettings()
	)
)

Macroscript PolyDrawConformDirView
category: ~POLYDRAW_CONFORMDIRVIEW_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYDRAW_CONFORMDIRVIEW_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		PolyToolsUI.PSConformDirection = 2
		PolyToolsUI.PolyShiftSettings()
	)
)

Macroscript SolveQuadsToggle
category: ~SOLVEQUADSTOGGLE_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~SOLVEQUADSTOGGLE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.PDSolveQuads
	)
	on execute do 
	(
		PolyToolsUI.PDSolveQuads = not PolyToolsUI.PDSolveQuads
	)
)

Macroscript PaintDeformPushPull
category: ~PAINTDEFORMPUSHPULL_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PAINTDEFORMPUSHPULL_TOOLTIP~
buttontext: ~PAINTDEFORMPUSHPULL_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.SculptButtons[1]
	)
	on execute do 
	(
		PolyToolsUI.SculptButtons[1] = not PolyToolsUI.SculptButtons[1]
		PolyBoost.ToolToggle 2 1 PolyToolsUI.SculptButtons[1]
	)
	on closedilaog do (false)
)

Macroscript PaintDeformPinchSpread
category: ~PAINTDEFORMPINCHSPREAD_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PAINTDEFORMPINCHSPREAD_TOOLTIP~
buttontext: ~PAINTDEFORMPINCHSPREAD_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.SculptButtons[2]
	)
	on execute do 
	(
		PolyToolsUI.SculptButtons[2] = not PolyToolsUI.SculptButtons[2]
		PolyBoost.ToolToggle 2 2 PolyToolsUI.SculptButtons[2]
	)
)

Macroscript PaintDeformFlatten
category: ~PAINTDEFORMFLATTEN_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PAINTDEFORMFLATTEN_TOOLTIP~
buttontext: ~PAINTDEFORMFLATTEN_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.SculptButtons[3]
	)
	on execute do 
	(
		PolyToolsUI.SculptButtons[3] = not PolyToolsUI.SculptButtons[3]
		PolyBoost.ToolToggle 2 3 PolyToolsUI.SculptButtons[3]
	)
)

Macroscript PaintDeformRelax
category: ~PAINTDEFORMRELAX_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PAINTDEFORMRELAX_TOOLTIP~
buttontext: ~PAINTDEFORMRELAX_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.SculptButtons[4]
	)
	on execute do 
	(
		PolyToolsUI.SculptButtons[4] = not PolyToolsUI.SculptButtons[4]
		PolyBoost.ToolToggle 2 4 PolyToolsUI.SculptButtons[4]
	)
)

Macroscript PaintDeformSmudge
category: ~PAINTDEFORMSMUDGE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PAINTDEFORMSMUDGE_TOOLTIP~
buttontext: ~PAINTDEFORMSMUDGE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.SculptButtons[5]
	)
	on execute do 
	(
		PolyToolsUI.SculptButtons[5] = not PolyToolsUI.SculptButtons[5]
		PolyBoost.ToolToggle 2 5 PolyToolsUI.SculptButtons[5]
	)
)

Macroscript PaintDeformNoise
category: ~PAINTDEFORMNOISE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PAINTDEFORMNOISE_TOOLTIP~
buttontext: ~PAINTDEFORMNOISE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.SculptButtons[6]
	)
	on execute do 
	(
		PolyToolsUI.SculptButtons[6] = not PolyToolsUI.SculptButtons[6]
		PolyBoost.ToolToggle 2 6 PolyToolsUI.SculptButtons[6]
	)
)

Macroscript PaintDeformExaggerate
category: ~PAINTDEFORMEXAGGERATE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PAINTDEFORMEXAGGERATE_TOOLTIP~
buttontext: ~PAINTDEFORMEXAGGERATE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.SculptButtons[7]
	)
	on execute do 
	(
		PolyToolsUI.SculptButtons[7] = not PolyToolsUI.SculptButtons[7]
		PolyBoost.ToolToggle 2 7 PolyToolsUI.SculptButtons[7]
	)
)

Macroscript PaintDeformRevert
category: ~PAINTDEFORMREVERT_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PAINTDEFORMREVERT_TOOLTIP~
buttontext: ~PAINTDEFORMREVERT_TOOLTIP~
autoUndoEnabled:false
(
	on isenabled do
	(
		PolyBSculptValidBuffer()
	)
	on isChecked do
	(
		PolyToolsUI.SculptButtons[8]
	)
	on execute do 
	(
		PolyToolsUI.SculptButtons[8] = not PolyToolsUI.SculptButtons[8]
		PolyBoost.ToolToggle 2 8 PolyToolsUI.SculptButtons[8]
	)
)

Macroscript PaintDeformCapToggle
category: ~PAINTDEFORMCAPTOGGLE_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~PAINTDEFORMCAPTOGGLE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.SculptCap
	)
	on execute do 
	(
		PolyToolsUI.SculptCap = not PolyToolsUI.SculptCap
		PolyToolsUI.PolySculptSettings()
	)
)

Macroscript PaintDeformRefreshButton
category: ~PAINTDEFORMREFRESHBUTTON_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~PAINTDEFORMREFRESHBUTTON_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled do
	(
		PolyToolsUI.SculptDirection == 1
	)
	on execute do 
	(
		PolyBSculptRefreshNormals()
	)
)

Macroscript PaintDeformCommit
category: ~PAINTDEFORMCOMMIT_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PAINTDEFORMCOMMIT_TOOLTIP~
buttontext: ~PAINTDEFORMCOMMIT_TOOLTIP~
autoUndoEnabled:false
(
	on isenabled do
	(
		PolyBSculptValidBuffer()
	)
	on execute do 
	(
		PolyBSculptCommitBuffer()
	)
)

Macroscript PaintDeformCancel
category: ~PAINTDEFORMCANCEL_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PAINTDEFORMCANCEL_TOOLTIP~
buttontext: ~PAINTDEFORMCANCEL_TOOLTIP~
autoUndoEnabled:false
(
	on isenabled do
	(
		PolyBSculptValidBuffer()
	)
	on execute do 
	(
		PolyBSculptCancelBuffer()
	)
)

Macroscript FreeformLoadSettings
category: ~FREEFORMLOADSETTINGS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~FREEFORMLOADSETTINGS_TOOLTIP~
buttontext: ~FREEFORMLOADSETTINGS_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		PolyBoost.FreeformLoadSettings()
	)
)

Macroscript FreeformSaveSettings
category: ~FREEFORMSAVESETTINGS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~FREEFORMSAVESETTINGS_TOOLTIP~
buttontext: ~FREEFORMSAVESETTINGS_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		PolyBoost.FreeformSaveSettings()
	)
)

Macroscript FreeformSetDefaultSettings
category: ~FREEFORMSETDEFAULTSETTINGS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~FREEFORMSETDEFAULTSETTINGS_TOOLTIP~
buttontext: ~FREEFORMSETDEFAULTSETTINGS_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		PolyBoost.FreeformSetDefaultSettings()
	)
)

Macroscript PolyShiftMove
category: ~POLYSHIFTMOVE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYSHIFTMOVE_TOOLTIP~
buttontext: ~POLYSHIFTMOVE_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return PolyBoost.ValidEPbasemacro()
	on isChecked do
	(
		PolyToolsUI.PSButtons[1]
	)
	on execute do 
	(
		PolyToolsUI.PSButtons[1] = not PolyToolsUI.PSButtons[1]
		PolyBoost.ToolToggle 3 1 PolyToolsUI.PSButtons[1]
	)
)

Macroscript PolyShiftScale
category: ~POLYSHIFTSCALE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYSHIFTSCALE_TOOLTIP~
buttontext: ~POLYSHIFTSCALE_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return PolyBoost.ValidEPbasemacro()
	on isChecked do
	(
		PolyToolsUI.PSButtons[2]
	)
	on execute do 
	(
		PolyToolsUI.PSButtons[2] = not PolyToolsUI.PSButtons[2]
		PolyBoost.ToolToggle 3 2 PolyToolsUI.PSButtons[2]
	)
)

Macroscript PolyShiftRotate
category: ~POLYSHIFTROTATE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~POLYSHIFTROTATE_TOOLTIP~
buttontext: ~POLYSHIFTROTATE_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return PolyBoost.ValidEPbasemacro()
	on isChecked do
	(
		PolyToolsUI.PSButtons[3]
	)
	on execute do 
	(
		PolyToolsUI.PSButtons[3] = not PolyToolsUI.PSButtons[3]
		PolyBoost.ToolToggle 3 3 PolyToolsUI.PSButtons[3]
	)
)

Macroscript PolyShiftUseSelectedToggle
category: ~POLYSHIFTUSESELECTEDTOGGLE_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYSHIFTUSESELECTEDTOGGLE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.PSUseSelected
	)
	on execute do 
	(
		PolyToolsUI.PSUseSelected = not PolyToolsUI.PSUseSelected
		PolyToolsUI.PolyShiftSettings()
	)
)

Macroscript PolyShiftIgnoreBackToggle
category: ~POLYSHIFTIGNOREBACKTOGGLE_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYSHIFTIGNOREBACKTOGGLE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.PSIgnoreback
	)
	on execute do 
	(
		PolyToolsUI.PSIgnoreback = not PolyToolsUI.PSIgnoreback
		PolyToolsUI.PolyShiftSettings()
	)
)

Macroscript PolyShiftFreezeXToggle
category: ~POLYSHIFTFREEZEXTOGGLE_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYSHIFTFREEZEXTOGGLE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.PSFreezeX
	on execute do 
	(
		PolyToolsUI.PSFreezeX = not PolyToolsUI.PSFreezeX
		PolyToolsUI.PolyShiftSettings()
	)
)

Macroscript PolyShiftFreezeYToggle
category: ~POLYSHIFTFREEZEYTOGGLE_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYSHIFTFREEZEYTOGGLE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.PSFreezeY
	on execute do 
	(
		PolyToolsUI.PSFreezeY = not PolyToolsUI.PSFreezeY
		PolyToolsUI.PolyShiftSettings()
	)
)

Macroscript PolyShiftFreezeZToggle
category: ~POLYSHIFTFREEZEZTOGGLE_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYSHIFTFREEZEZTOGGLE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.PSFreezeZ
	on execute do 
	(
		PolyToolsUI.PSFreezeZ = not PolyToolsUI.PSFreezeZ
		PolyToolsUI.PolyShiftSettings()
	)
)

Macroscript PolyShiftFreezeEXToggle
category: ~POLYSHIFTFREEZEEXTOGGLE_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYSHIFTFREEZEEXTOGGLE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.PSFreezeEX
	on execute do 
	(
		PolyToolsUI.PSFreezeEX = not PolyToolsUI.PSFreezeEX
		PolyToolsUI.PolyShiftSettings()
	)
)

Macroscript PolyShiftFreezeEYToggle
category: ~POLYSHIFTFREEZEEYTOGGLE_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYSHIFTFREEZEEYTOGGLE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.PSFreezeEY
	on execute do 
	(
		PolyToolsUI.PSFreezeEY = not PolyToolsUI.PSFreezeEY
		PolyToolsUI.PolyShiftSettings()
	)
)

Macroscript PolyShiftFreezeEZToggle
category: ~POLYSHIFTFREEZEEZTOGGLE_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYSHIFTFREEZEEZTOGGLE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.PSFreezeEZ
	on execute do 
	(
		PolyToolsUI.PSFreezeEZ = not PolyToolsUI.PSFreezeEZ
		PolyToolsUI.PolyShiftSettings()
	)
)

Macroscript PolyShiftMirrorToggle
category: ~POLYSHIFTMIRRORTOGGLE_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYSHIFTMIRRORTOGGLE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.PSMirror
	on execute do 
	(
		PolyToolsUI.PSMirror = not PolyToolsUI.PSMirror
		PolyToolsShift.UseMirror = PolyToolsUI.PSMirror
	)
)

Macroscript PolyShiftMirrorX
category: ~POLYSHIFTMIRRORX_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYSHIFTMIRRORX_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do (PolyToolsUI.PSMirrorAxis == #X)
	on execute do 
	(
		PolyToolsUI.PSMirrorAxis = #X
		PolyToolsShift.SetMirrorAxis PolyToolsUI.PSMirrorAxis
	)
)

Macroscript PolyShiftMirrorY
category: ~POLYSHIFTMIRRORY_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYSHIFTMIRRORY_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do (PolyToolsUI.PSMirrorAxis == #Y)
	on execute do 
	(
		PolyToolsUI.PSMirrorAxis = #Y
		PolyToolsShift.SetMirrorAxis PolyToolsUI.PSMirrorAxis
	)
)

Macroscript PolyShiftMirrorZ
category: ~POLYSHIFTMIRRORZ_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYSHIFTMIRRORZ_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do (PolyToolsUI.PSMirrorAxis == #Z)
	on execute do 
	(
		PolyToolsUI.PSMirrorAxis = #Z
		PolyToolsShift.SetMirrorAxis PolyToolsUI.PSMirrorAxis
	)
)

Macroscript PolyShiftAffectSpherical
category: ~POLYSHIFTAFFECTSPHERICAL_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYSHIFTAFFECTSPHERICAL_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		PolyToolsUI.PSBrushAffect = 1
		PolyToolsUI.PolyShiftSettings()
	)
)

Macroscript PolyShiftAffectDepth
category: ~POLYSHIFTAFFECTDEPTH_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYSHIFTAFFECTDEPTH_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		PolyToolsUI.PSBrushAffect = 2
		PolyToolsUI.PolyShiftSettings()
	)
)

Macroscript UVWTweak
category: ~UVWTWEAK_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~UVWTWEAK_TOOLTIP~
buttontext: ~UVWTWEAK_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return PolyBoost.ValidEPbasemacro()
	on isChecked do
	(
		PolyToolsUI.UVWTweakButton
	)
	on execute do 
	(
		PolyToolsUI.UVWTweakButton = not PolyToolsUI.UVWTweakButton
		PolyBoost.ToolToggle 4 1 PolyToolsUI.UVWTweakButton
	)
)

Macroscript Store1Button
category: ~STORE1BUTTON_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~STORE1BUTTON_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return PolyBoost.ValidEPmacro()
	on isChecked do
	(
		PolyToolsUI.StoreSelButton1
	)
	on execute do 
	(
		PolyToolsUI.StoreSelButton1 = true
		if (subobjectLevel == 1) then PolyBoost.SelStorage1 = PolyBGetSel 1
		else if (subobjectLevel == 2) or (subobjectLevel == 3) then PolyBoost.SelStorage1 = PolyBGetSel 2
		else if (subobjectLevel == 4) or (subobjectLevel == 5) do PolyBoost.SelStorage1 = PolyBGetSel 3
	)
)

Macroscript Store2Button
category: ~STORE2BUTTON_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~STORE2BUTTON_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return PolyBoost.ValidEPmacro()
	on isChecked do
	(
		PolyToolsUI.StoreSelButton2
	)
	on execute do 
	(
		PolyToolsUI.StoreSelButton2 = true
		if (subobjectLevel == 1) then PolyBoost.SelStorage2 = PolyBGetSel 1
		else if (subobjectLevel == 2) or (subobjectLevel == 3) then PolyBoost.SelStorage2 = PolyBGetSel 2
		else if (subobjectLevel == 4) or (subobjectLevel == 5) do PolyBoost.SelStorage2 = PolyBGetSel 3
	)
)

Macroscript SelectRandomNumber
category: ~SELECTRANDOMNUMBER_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~SELECTRANDOMNUMBER_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.RandomNumberButton
	)
	on execute do 
	(
		if not PolyToolsUI.RandomNumberButton do
		(
			PolyToolsUI.RandomNumberButton = true
			PolyToolsUI.RandomType = 2
			PolyToolsUI.RandomPercentButton = false
		)
		updateToolbarButtons()
	)
)

Macroscript SelectRandomPercent
category: ~SELECTRANDOMPERCENT_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~SELECTRANDOMPERCENT_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.RandomPercentButton
	)
	on execute do 
	(
		if not PolyToolsUI.RandomPercentButton do
		(
			PolyToolsUI.RandomPercentButton = true
			PolyToolsUI.RandomType = 1
			PolyToolsUI.RandomNumberButton = false
		)
		updateToolbarButtons()
	)
)

Macroscript UVWTweakKeepBoundriesToggle
category: ~UVWTWEAKKEEPBOUNDRIESTOGGLE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~UVWTWEAKKEEPBOUNDRIESTOGGLE_TOOLTIP~
buttontext: ~UVWTWEAKKEEPBOUNDRIESTOGGLE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.UVWTweakKeepBoundries
	)
	on execute do 
	(
		PolyToolsUI.UVWTweakKeepBoundries = not PolyToolsUI.UVWTweakKeepBoundries
		PolyToolsUI.UVWTweakSettings()
	)
)

Macroscript MirrorElementX
category: ~MIRRORELEMENTX_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~MIRRORELEMENTX_TOOLTIP~
buttontext: ~MIRRORELEMENTX_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsModeling.MirrorElement #X PolyToolsUI.MirrorElementClone
)

Macroscript MirrorElementY
category: ~MIRRORELEMENTY_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~MIRRORELEMENTY_TOOLTIP~
buttontext: ~MIRRORELEMENTY_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsModeling.MirrorElement #Y PolyToolsUI.MirrorElementClone
)

Macroscript MirrorElementZ
category: ~MIRRORELEMENTZ_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~MIRRORELEMENTZ_TOOLTIP~
buttontext: ~MIRRORELEMENTZ_TOOLTIP~
autoUndoEnabled:false
(
on isEnabled return PolyBoost.ValidEPmacro()
on execute do PolyToolsModeling.MirrorElement #Z PolyToolsUI.MirrorElementClone
)

Macroscript MirrorElementCloneToggle
category: ~MIRRORELEMENTCLONETOGGLE_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~MIRRORELEMENTCLONETOGGLE_TOOLTIP~
buttontext: ~MIRRORELEMENTCLONETOGGLE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.MirrorElementClone
	)
	on execute do 
	(
		PolyToolsUI.MirrorElementClone = not PolyToolsUI.MirrorElementClone
	)
)

Macroscript ObjectPaintPaintSelected
category: ~OBJECTPAINTPAINT_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~OBJECTPAINTPAINTSELECTED_TOOLTIP~
buttontext: ~OBJECTPAINTPAINTSELECTED_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return
	(
		not (OBJPaintGetSetting 51)
	)
	on isChecked do
	(
		OBJPaintGetSetting 50 and (OBJPaintGetSetting 39) == 1
	)
	on execute do 
	(
		doStartTool = not (OBJPaintGetSetting 50)
		OBJPaintSetSetting 39 1
		PolyBoost.ToolToggle 5 1 doStartTool
	)
)

Macroscript ObjectPaintPaint
category: ~OBJECTPAINTPAINT_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~OBJECTPAINTPAINT_TOOLTIP~
buttontext: ~OBJECTPAINTPAINT_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return
	(
		not (OBJPaintGetSetting 51)
	)
	on isChecked do
	(
		OBJPaintGetSetting 50 and (OBJPaintGetSetting 39) == 2
	)
	on execute do 
	(
		doStartTool = not (OBJPaintGetSetting 50)
		OBJPaintSetSetting 39 2
		PolyBoost.ToolToggle 5 1 doStartTool
	)
)

Macroscript ObjectPaintFill
category: ~OBJECTPAINTFILL_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~OBJECTPAINTFILL_TOOLTIP~
buttontext: ~OBJECTPAINTFILL_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return
	(
		(PolyBoost.ValidEPmacro() and subobjectlevel == 2) or (OBJPaintGetSetting 51)
	)
	on isChecked do
	(
		OBJPaintGetSetting 51
	)
	on execute do 
	(
		doStartTool = not (OBJPaintGetSetting 51)
		PolyBoost.ToolToggle 5 2 doStartTool
	)
)

Macroscript ObjectPaintPickObject
category: ~OBJECTPAINTPICKOBJECT_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~OBJECTPAINTPICKOBJECT_TOOLTIP~
buttontext: ~OBJECTPAINTPICKOBJECT_TOOLTIP~
autoUndoEnabled:false
(
	on isenabled return
	(
		not ((OBJPaintGetSetting 50) or (OBJPaintGetSetting 51))
	)
	on isChecked do
	(
		ObjectPaint.IsPickingObject
	)
	on execute do 
	(
		if ObjectPaint.IsPickingObject then
		(
			max move
		)
		else
		(
			ObjectPaint.IsPickingObject = true
			ObjectPaint.ObjectPaintPickObject()
		)
		ObjectPaint.IsPickingObject = false
		updateToolbarButtons()
	)
)

Macroscript ObjectPaintNodeDialog
category: ~OBJECTPAINTNODEDIALOG_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~OBJECTPAINTNODEDIALOG_TOOLTIP~
buttontext: ~OBJECTPAINTNODEDIALOG_TOOLTIP~
autoUndoEnabled:false
(
	on isenabled return
	(
		--disable when paint with selected is active
		not (OBJPaintGetSetting 50 and OBJPaintGetSetting 39 == 1)
	)
	on isChecked do
	(
		ObjectPaint.NodeDialogOpen
	)
	on execute do 
	(
		if ObjectPaint.NodeDialogOpen then destroyDialog ObjectPaintNodeDialog
		else ObjectPaint.OpenNodeDialog()
	)
)

Macroscript ObjectPaintTypeGrid
category: ~OBJECTPAINTTYPEGRID_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~OBJECTPAINTTYPEGRID_TOOLTIP~
buttontext: ~OBJECTPAINTTYPEGRID_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		OBJPaintSetSetting 18 1
		updateToolbarButtons()
	)
)

Macroscript ObjectPaintTypeSelected
category: ~OBJECTPAINTTYPESELECTED_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~OBJECTPAINTTYPESELECTED_TOOLTIP~
buttontext: ~OBJECTPAINTTYPESELECTED_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		OBJPaintSetSetting 18 2
		updateToolbarButtons()
	)
)

Macroscript ObjectPaintTypeScene
category: ~OBJECTPAINTTYPESCENE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~OBJECTPAINTTYPESCENE_TOOLTIP~
buttontext: ~OBJECTPAINTTYPESCENE_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		OBJPaintSetSetting 18 3
		updateToolbarButtons()
	)
)

Macroscript ObjectPaintMotionTypeRandom
category: ~OBJECTPAINTMOTIONTYPERANDOM_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTMOTIONTYPERANDOM_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		OBJPaintSetSetting 37 true
		updateToolbarButtons()
	)
)

Macroscript ObjectPaintMotionTypeConsecutive
category: ~OBJECTPAINTMOTIONTYPECONSECUTIVE_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTMOTIONTYPECONSECUTIVE_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		OBJPaintSetSetting 37 false
		updateToolbarButtons()
	)
)

Macroscript ObjectPaintPaintOnPainted
category: ~OBJECTPAINTPAINTONPAINTED_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTPAINTONPAINTED_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		OBJPaintGetSetting 20
	)
	on execute do 
	(
		OBJPaintSetSetting 20 (not OBJPaintGetSetting 20)
		updateToolbarButtons()
	)
)

Macroscript ObjectPaintCommit
category: ~OBJECTPAINTCOMMIT_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~OBJECTPAINTCOMMIT_TOOLTIP~
buttontext: ~OBJECTPAINTCOMMIT_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return
	(
		(OBJPaintGetSetting 50 or OBJPaintGetSetting 51)
	)
	on execute do 
	(
		PolyBOBJPaintCommit()
	)
)

Macroscript ObjectPaintCancel
category: ~OBJECTPAINTCANCEL_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~OBJECTPAINTCANCEL_TOOLTIP~
buttontext: ~OBJECTPAINTCANCEL_TOOLTIP~
autoUndoEnabled:false
(
	on isEnabled return
	(
		(OBJPaintGetSetting 50 or OBJPaintGetSetting 51)
	)
	on execute do 
	(
		PolyBOBJPaintClear()
	)
)

Macroscript ObjectPaintAlignX
category: ~OBJECTPAINTALIGNX_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTALIGNX_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		OBJPaintGetSetting 14 == 1
	)
	on execute do 
	(
		OBJPaintSetSetting 14 1
		PolyBOBJInterActiveUpdate()
		updateToolbarButtons()
	)
)

Macroscript ObjectPaintAlignY
category: ~OBJECTPAINTALIGNY_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTALIGNY_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		OBJPaintGetSetting 14 == 2
	)
	on execute do 
	(
		OBJPaintSetSetting 14 2
		PolyBOBJInterActiveUpdate()
		updateToolbarButtons()
	)
)

Macroscript ObjectPaintAlignZ
category: ~OBJECTPAINTALIGNZ_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTALIGNZ_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		OBJPaintGetSetting 14 == 3
	)
	on execute do 
	(
		OBJPaintSetSetting 14 3
		PolyBOBJInterActiveUpdate()
		updateToolbarButtons()
	)
)

Macroscript ObjectPaintFlipAxis
category: ~OBJECTPAINTFLIPAXIS_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTFLIPAXIS_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		OBJPaintGetSetting 15
	)
	on execute do 
	(
		OBJPaintSetSetting 15 (not OBJPaintGetSetting 15)
		PolyBOBJInterActiveUpdate()
		updateToolbarButtons()
	)
)

Macroscript ObjectPaintScaleTypeEven
category: ~OBJECTPAINTSCALETYPEEVEN_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTSCALETYPEEVEN_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		OBJPaintSetSetting 27 1
		PolyBOBJInterActiveUpdate()
	)
)

Macroscript ObjectPaintScaleTypeRandom
category: ~OBJECTPAINTSCALETYPERANDOM_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTSCALETYPERANDOM_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		OBJPaintSetSetting 27 2
		PolyBOBJInterActiveUpdate()
	)
)

Macroscript ObjectPaintScaleTypeRamp
category: ~OBJECTPAINTSCALETYPERAMP_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTSCALETYPERAMP_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		OBJPaintSetSetting 27 3
		PolyBOBJInterActiveUpdate()
	)
)

Macroscript ObjectPaintScaleAxisLock
category: ~OBJECTPAINTSCALEAXISLOCK_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTSCALEAXISLOCK_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		OBJPaintGetSetting 28
	)
	on execute do 
	(
		OBJPaintSetSetting 28 (not OBJPaintGetSetting 28)
		updateToolbarButtons()
		PolyBOBJInterActiveUpdate()
	)
)

Macroscript ObjectPaintLoadSettings
category: ~OBJECTPAINTLOADSETTINGS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~OBJECTPAINTLOADSETTINGS_TOOLTIP~
buttontext: ~OBJECTPAINTLOADSETTINGS_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		settingsdir = getdir #plugcfg_ln + ("\\PolyTools\\ObjectPaint\\Settings\\")
		settingsfilename = GetOpenFileName caption:~GETOPENFILENAME_CAPTION~ filename:settingsdir types:"Text(*.txt)|*.txt|"
		if settingsfilename != undefined do
		(
			settingsfile = openFile settingsfilename
			if settingsfile != undefined do
			(
				settings = execute (readline settingsfile)
				close settingsfile
				numsettings = settings.count
				for i = 1 to numsettings do
				(
					OBJPaintSetSetting i settings[i]
				)
				updateToolbarButtons()
				PolyBOBJInterActiveUpdate()
			)
		)
	)
)

Macroscript ObjectPaintSaveSettings
category: ~OBJECTPAINTSAVESETTINGS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~OBJECTPAINTSAVESETTINGS_TOOLTIP~
buttontext: ~OBJECTPAINTSAVESETTINGS_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		settingsdir = getdir #plugcfg_ln + ("\\PolyTools\\ObjectPaint\\Settings\\")
		settingsfiledir = settingsdir + "ObjectPaint_Settings_01.txt"
		settingsfilename = GetSaveFileName caption:~OBJECTPAINTSAVESETTINGS_GETSAVEFILENAME_CAPTION~ filename:settingsfiledir types:"Text(*.txt)|*.txt|"
		if settingsfilename != undefined do
		(
			if (doesFileExist settingsfilename) and (getFileAttribute settingsFileName #readOnly) do
			(
				setFileAttribute settingsfilename #readOnly false
			)
			settingsfile = createfile settingsfilename
			if settingsfile != undefined do
			(
				format "#(" to:settingsfile
				for i = 1 to 37 do
				(
					curset = (OBJPaintGetSetting i) as string
					format curset to:settingsfile
					if i < 37 do format "," to:settingsfile
				)
				format ")" to:settingsfile
				close settingsfile
			)
		)
	)
)

Macroscript ObjectPaintSetDefaultSettings
category: ~OBJECTPAINTSETDEFAULTSETTINGS_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~OBJECTPAINTSETDEFAULTSETTINGS_TOOLTIP~
buttontext: ~OBJECTPAINTSETDEFAULTSETTINGS_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		if (querybox ~QUERYBOX_OBJECTPAINTSETDEFAULTSETTINGS_CAPTION~ title:~QUERYBOX_OBJECTPAINTSETDEFAULTSETTINGS_TITLE~) do
		(
			settingsdir = getdir #plugcfg_ln + ("\\PolyTools\\ObjectPaint\\Settings\\")
			settingsfilename = settingsdir + "Default.txt"
			if not (doesFileExist settingsfilename) do
			(
				createfile settingsfilename
			)
			if (doesFileExist settingsfilename) and (getFileAttribute settingsfilename #readOnly) do
			(
				setFileAttribute settingsfilename #readOnly false
			)
			settingsfile = openFile settingsfilename mode:"w+"
			if settingsfile != undefined do
			(
				format "#(" to:settingsfile
				for i = 1 to 37 do
				(
					curset = (OBJPaintGetSetting i) as string
					format curset to:settingsfile
					if i < 37 do format "," to:settingsfile
				)
				format ")" to:settingsfile
				close settingsfile
			)
		)
	)
)

Macroscript ObjectPaintRandomNodeOrder
category: ~OBJECTPAINTRANDOMNODEORDER_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTRANDOMNODEORDER_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		OBJPaintSetSetting 27 1
		PolyBOBJInterActiveUpdate()
	)
)

Macroscript ObjectPaintUseNodesButton
category: ~OBJECTPAINTUSENODESBUTTON_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTUSENODESBUTTON_TOOLTIP~
autoUndoEnabled:false
(
	on isenabled return
	(
		--disable when paint with selected is active
		not (OBJPaintGetSetting 50 and OBJPaintGetSetting 39 == 1)
	)
)

Macroscript ObjectPaintUseNodesSingle
category: ~OBJECTPAINTUSENODESSINGLE_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTUSENODESSINGLE_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		OBJPaintSetSetting 16 false
		OBJPaintSetSetting 38 false
	)
)

Macroscript ObjectPaintUseNodesAllInOrder
category: ~OBJECTPAINTUSENODESALLINORDER_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTUSENODESALLINORDER_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		OBJPaintSetSetting 16 false
		OBJPaintSetSetting 38 true
	)
)

Macroscript ObjectPaintUseNodesAllRandomly
category: ~OBJECTPAINTUSENODESALLRANDOMLY_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTUSENODESALLRANDOMLY_TOOLTIP~
autoUndoEnabled:false
(
	on execute do 
	(
		OBJPaintSetSetting 16 true
		OBJPaintSetSetting 38 true
	)
)

Macroscript ObjectPaintAlignToNormal
category: ~OBJECTPAINTALIGNTONORMAL_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTALIGNTONORMAL_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do OBJPaintGetSetting 17
	on execute do 
	(
		OBJPaintSetSetting 17 (not (OBJPaintGetSetting 17))
		PolyBOBJInterActiveUpdate()
	)
)

Macroscript ObjectPaintFollowStroke
category: ~OBJECTPAINTFOLLOWSTROKE_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTFOLLOWSTROKE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		OBJPaintGetSetting 13
	)
	on execute do 
	(
		OBJPaintSetSetting 13 (not (OBJPaintGetSetting 13))
		PolyBOBJInterActiveUpdate()
	)
)

Macroscript ObjectPaintRotateRandomX
category: ~OBJECTPAINTROTATERANDOMX_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTROTATERANDOMX_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		OBJPaintGetSetting 9
	)
	on execute do 
	(
		OBJPaintSetSetting 9 (not (OBJPaintGetSetting 9))
		PolyBOBJInterActiveUpdate()
	)
)

Macroscript ObjectPaintRotateRandomY
category: ~OBJECTPAINTROTATERANDOMY_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTROTATERANDOMY_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		OBJPaintGetSetting 10
	)
	on execute do 
	(
		OBJPaintSetSetting 10 (not (OBJPaintGetSetting 10))
		PolyBOBJInterActiveUpdate()
	)
)

Macroscript ObjectPaintRotateRandomZ
category: ~OBJECTPAINTROTATERANDOMZ_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~OBJECTPAINTROTATERANDOMZ_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		OBJPaintGetSetting 11
	)
	on execute do 
	(
		OBJPaintSetSetting 11 (not (OBJPaintGetSetting 11))
		PolyBOBJInterActiveUpdate()
	)
)

Macroscript SimilarEdgeCount
category: ~SIMILAREDGECOUNT_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~SIMILAREDGECOUNT_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		if subobjectlevel == 1 then PolyToolsUI.SimilarV[1]
		else PolyToolsUI.SimilarF[1]
	)
	on execute do 
	(
		if subobjectlevel == 1 then
		(
			PolyToolsUI.SimilarV[1] = not PolyToolsUI.SimilarV[1]
		)
		else
		(
			PolyToolsUI.SimilarF[1] = not PolyToolsUI.SimilarF[1]
		)
	)
)

Macroscript SimilarFaceAreas
category: ~SIMILARFACEAREAS_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~SIMILARFACEAREAS_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		if subobjectlevel == 1 then PolyToolsUI.SimilarV[4]
		else if subobjectlevel == 2 or  subobjectlevel == 3 then PolyToolsUI.SimilarE[2]
		else PolyToolsUI.SimilarF[2]
	)
	on execute do 
	(
		if subobjectlevel == 1 then
		(
			PolyToolsUI.SimilarV[4] = not PolyToolsUI.SimilarV[4]
		)
		else if subobjectlevel == 2 or  subobjectlevel == 3 then
		(
			PolyToolsUI.SimilarE[2] = not PolyToolsUI.SimilarE[2]
		)
		else
		(
			PolyToolsUI.SimilarF[2] = not PolyToolsUI.SimilarF[2]
		)
	)
)

Macroscript SimilarTopology
category: ~SIMILARTOPOLOGY_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~SIMILARTOPOLOGY_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		if subobjectlevel == 2 or  subobjectlevel == 3 then PolyToolsUI.SimilarE[3]
		else PolyToolsUI.SimilarF[3]
	)
	on execute do 
	(
		if subobjectlevel == 2 or  subobjectlevel == 3 then
		(
			PolyToolsUI.SimilarE[3] = not PolyToolsUI.SimilarE[3]
		)
		else
		(
			PolyToolsUI.SimilarF[3] = not PolyToolsUI.SimilarF[3]
		)
	)
)

Macroscript SimilarNormal
category: ~SIMILARNORMAL_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~SIMILARNORMAL_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		if subobjectlevel == 1 then PolyToolsUI.SimilarV[5]
		else if subobjectlevel == 2 or  subobjectlevel == 3 then PolyToolsUI.SimilarE[4]
		else PolyToolsUI.SimilarF[4]
	)
	on execute do 
	(
		if subobjectlevel == 1 then
		(
			PolyToolsUI.SimilarV[5] = not PolyToolsUI.SimilarV[5]
		)
		else if subobjectlevel == 2 or  subobjectlevel == 3 then
		(
			PolyToolsUI.SimilarE[4] = not PolyToolsUI.SimilarE[4]
		)
		else
		(
			PolyToolsUI.SimilarF[4] = not PolyToolsUI.SimilarF[4]
		)
	)
)

Macroscript SimilarEdgeLength
category: ~SIMILAREDGELENGTH_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~SIMILAREDGELENGTH_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		if subobjectlevel == 1 then PolyToolsUI.SimilarV[2]
		else PolyToolsUI.SimilarE[1]
	)
	on execute do 
	(
		if subobjectlevel == 1 then
		(
			PolyToolsUI.SimilarV[2] = not PolyToolsUI.SimilarV[2]
		)
		else
		(
			PolyToolsUI.SimilarE[1] = not PolyToolsUI.SimilarE[1]
		)
	)
)

Macroscript SimilarFaceCount
category: ~SIMILARFACECOUNT_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~SIMILARFACECOUNT_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.SimilarV[3]
	on execute do 
	(
		PolyToolsUI.SimilarV[3] = not PolyToolsUI.SimilarV[3]
	)
)

Macroscript PolyDrawSetFlow
category: ~POLYDRAWSETFLOW_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYDRAWSETFLOW_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.PDSetFlow
	on execute do 
	(
		PolyToolsUI.PDSetFlow = not PolyToolsUI.PDSetFlow
		PolyToolsUI.PolyDrawSettings()
	)
)

Macroscript FlowConnectAutoRing
category: ~FLOWCONNECTAUTORING_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~FLOWCONNECTAUTORING_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.FlowConnectAutoLoop
	on execute do 
	(
		PolyToolsUI.FlowConnectAutoLoop = not PolyToolsUI.FlowConnectAutoLoop
	)
)

Macroscript SetFlowAutoLoop
category: ~SETFLOWAUTOLOOP_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~SETFLOWAUTOLOOP_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.SetFlowAutoLoop
	on execute do 
	(
		PolyToolsUI.SetFlowAutoLoop = not PolyToolsUI.SetFlowAutoLoop
	)
)

Macroscript RandomConnectAutoLoop
category: ~RANDOMCONNECTAUTOLOOP_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~RANDOMCONNECTAUTOLOOP_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.RandomConnectAutoLoop
	on execute do 
	(
		PolyToolsUI.RandomConnectAutoLoop = not PolyToolsUI.RandomConnectAutoLoop
	)
)

Macroscript PolyDrawSurfaceQuads
category: ~POLYDRAWSURFACEQUADS_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYDRAWSURFACEQUADS_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.PDSurfQuads
	on execute do 
	(
		PolyToolsUI.PDSurfQuads = not PolyToolsUI.PDSurfQuads
		PolyToolsUI.PolyDrawSettings()
	)
)

Macroscript PolyDrawTopologyWeld
category: ~POLYDRAWTOPOLOGYWELD_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~POLYDRAWTOPOLOGYWELD_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do PolyToolsUI.PDAutoWeld
	on execute do 
	(
		PolyToolsUI.PDAutoWeld = not PolyToolsUI.PDAutoWeld
		PolyToolsUI.PolyDrawSettings()
	)
)

Macroscript PaintDeformToggleUseSplineConstraint
category: ~PAINTDEFORMUSESPLINE_CATEGORY~
internalCategory: "PolyTools"
tooltip: ~PAINTDEFORMUSESPLINE_TOOLTIP~
buttontext: ~PAINTDEFORMUSESPLINE_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do thePainterInterface.useSplineConstraint
	on execute do 
	(
		thePainterInterface.useSplineConstraint = not thePainterInterface.useSplineConstraint
		updateToolbarButtons()
	)
)

Macroscript PaintDeformPickButton
category: ~PAINTDEFORMPICKBUTTON_CATEGORY~
internalCategory: "Ribbon - Modeling"
tooltip: ~PAINTDEFORMPICKBUTTON_TOOLTIP~
autoUndoEnabled:false
(
	on isChecked do
	(
		PolyToolsUI.SculptPickButton
	)
	on execute do 
	(
		if PolyToolsUI.SculptPickButton then
		(
			PolyToolsUI.SculptPickButton = false
			max move
		)
		else PolyBoost.PaintDeformPickNode()
	)
)

